string GetDescription()
{
	return "Drums - generates a snare attack pattern";
}

void Render(RenderPart @p)
{
	double speed = 0.25;
	
	double vel_from = 30+RndInt(0,20);
	double vel_off = 90 - vel_from;
	
	double delta = (p.GetEndBar() - p.GetStartBar()) * p.GetUniquePart().GetMetrum();
	double alpha = 0;
	
	int speed_up = RndInt(0,2);
	
	int mode = RndInt(0,1);
	
	if (p.GetTempo() < 90) speed /= 2.0;
	
	if (p.GetEndBar() - p.GetStartBar() < 3) speed_up = 0;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		Time t = CreateTime(i, 0);
		while (t.m_Pos < p.GetUniquePart().GetMetrum())
		{
			Time t2 = CreateTime(i, t.m_Pos +0.1);
			p.AddPercNote(t,t2,38, (vel_from + ((alpha / delta) * vel_off)));
			
			if(mode == 0)p.AddPercNote(t,t2,42, (vel_from + ((alpha / delta) * vel_off)));
			
			t.m_Pos += speed;	
			alpha += speed;	
			
			if (speed_up == 1 && i == p.GetEndBar()-1 && t.m_Pos > p.GetUniquePart().GetMetrum()/2.0) 
			{
				speed_up = 0;
				speed /= 2.0;	
			}
		}
		
		if (speed_up == 2 && i == p.GetEndBar()-2) 
		{
			speed_up = 0;
			speed /= 2.0;	
		}
	}
	
	p.AddPercNote( CreateTime(p.GetEndBar(), 0), CreateTime(p.GetEndBar(), 0.1), 49, 120);
	p.AddPercNote( CreateTime(p.GetEndBar(), 0), CreateTime(p.GetEndBar(), 0.1), 57, 120);
	
}